	function [G, Z, P] = MAX_FLAT_TAU(Tau, N)
 
	% Computes, according to J.-P. Thiran, the poles and zeros for a
	%  recursive filter with maximally flat group delay, where Tau is 
	% the maximum group delay. Tau most be > 0 to ensure a stable filter. 
 
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2010-11-15
	% Modified by: 	 
	% Copyright:		by authors - not released for commercial use
	% Version:	1		 
	% Known bugs:		
	% Report bugs to:	Wanhammar@gmail.com
	
	G = FACTORIAL(2*N)/FACTORIAL(N)/prod([N+1,2*N]+2*Tau);
	B = [];
	for k = 0:N
		B = 1;
		for n = 0:N
			B = B*(2*Tau+n)/(2*Tau+n+k);
		end
		Denum(k+1) = FACTORIAL(N)/FACTORIAL(k)/FACTORIAL(N-k)*B*(-1)^k;	
	end	
	P = roots(Denum);
	Z = [zeros(1,length(P))]';
	G = real(prod(1-P));
